import SpacePage from '../pages/spaces/SpacePage'
import SpacePagesPage from '../pages/spaces/SpacePagesPage'

import { withFetch } from 'inside-collection/hocs'
import { fetchSpace, fetchTabSpace } from '../pages/spaces/fetch'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false
    }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'SpacesListingPage',
    component: () => import('../pages/spaces/SpacesListingPage'),
    path: '/espaces'
  },
  {
    name: 'SpacePage',
    component: withFetch(SpacePage, { size: 'xxl', watch: true })(fetchSpace),
    path: '/espaces/:slug'
  },
  {
    name: 'SpacePagesPage',
    component: withFetch(SpacePagesPage, { size: 'xxl', watch: true })(
      fetchTabSpace
    ),
    path: '/espaces/:slug/pages'
  },
  {
    name: 'FormPage',
    meta: { disabled: true }
  },
  {
    name: 'OrganizationsListingPage',
    props: {
      gridMinMax: '300',
      cardHeight: 's'
    }
  }
]
