import { http } from '@inside-library/helpers/Http'

const fetchItemFromUUID = async (endpoint, uuid, fields) => {
  const { data } = await http.get(endpoint, {
    fields,
    filters: { 'uuid:eq': uuid }
  })

  return data[0]
}

export default {
  spaces: {
    add: async ({ data }) => {
      const space = await fetchItemFromUUID('content/spaces', data.uuid, [
        'uuid',
        'slug'
      ])

      return {
        name: 'SpacePage',
        params: { slug: space?.slug[0] }
      }
    },
    delete: () => ({
      name: 'SpacesListingPage'
    }),
    globalSearch: () => ({ routeAs: 'add' })
  },
  pagesCategories: {
    add: async ({ data }) => {
      const category = await fetchItemFromUUID(
        'content/pages_categories',
        data.uuid,
        ['uuid', { spaces: ['uuid', 'slug'] }]
      )

      return {
        name: 'SpacePagesPage',
        params: { slug: category?.spaces?.slug[0] }
      }
    },
    delete: async ({ uuid }) => {
      const category = await fetchItemFromUUID(
        'content/pages_categories',
        uuid,
        ['uuid', { spaces: ['uuid', 'slug'] }]
      )

      return {
        name: 'SpacePagesPage',
        params: { slug: category?.spaces?.slug[0] }
      }
    },
    globalSearch: () => ({ routeAs: 'add' })
  },
  spacesPages: {
    add: async ({ data }) => {
      const page = await fetchItemFromUUID('content/spaces_pages', data.uuid, [
        'uuid',
        { pages_categories: ['uuid', { spaces: ['uuid', 'slug'] }] }
      ])

      return {
        name: 'SpacePagesPage',
        params: { slug: page?.pages_categories?.spaces?.slug[0] },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const page = await fetchItemFromUUID('content/spaces_pages', uuid, [
        'uuid',
        { pages_categories: ['uuid', { spaces: ['uuid', 'slug'] }] }
      ])

      return {
        name: 'SpacePagesPage',
        params: { slug: page?.pages_categories?.spaces?.slug[0] }
      }
    },
    globalSearch: () => ({ routeAs: 'add' })
  }
}
