<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

final class BcaeUpdatePermissibleAttrForPages extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        collect([
            'spaces_pages','pages_categories'
        ])->each(function ($type) {
            $this->getBridge()?->contentTypeUpdate($type, [
                'permissible' => true,
            ]);
        });
        $this->finishUp();
    }
}
