<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class FixUsersSearchableFieldsForBcae extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();
        $entities = collect(['services','parks','regions']);

        $entities->each(
            fn ($type) =>  $bridgeContentType->updateContentTypeOptions(
                type: $type,
                options: [
                    'searchable' => true,
                ]
            )
        );

        $entities->each(
            fn ($fieldName) =>  $bridgeContentType->updateFieldOptions(
                type: 'users',
                fieldName: $fieldName,
                options: [
                    'searchable' => true,
                ]
            )
        );

        Artisan::call('models:rebuild');
        Artisan::call('index:rebuild --type=users');
    }
}
