<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\ToolsCategories;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class CreateAndAssignDefaultToolsForBcae extends Migration
{
    public function up(): void
    {
        $defaultTools = [
            'Outil 1' => 0,
            'Outil 2' => 1,
            'Outil 3' => 2,
            'Outil 4' => 3,
            'Outil 5' => 4,
        ];

        $existingTools = Tools::query()
            ->whereIn('title', array_keys($defaultTools))
            ->get()
            ->sortBy(fn ($tool) => $defaultTools[$tool->title])
            ->pluck('title')
            ->toArray();

        $toolsToCreate = array_diff(array_keys($defaultTools), $existingTools);

        $toolsCategory = ToolsCategories::where('title', 'IT')->first();
        if (!$toolsCategory) {
            throw new \Exception("La catégorie d'outils 'IT' n'existe pas.");
        }

        $bridge = new BridgeContent();
        collect($toolsToCreate)->each(function ($title) use ($bridge, $defaultTools, $toolsCategory) {
            $bridge->contentUpdate(
                type: 'tools',
                data: [
                    'title' => $title,
                    'weight' => $defaultTools[$title],
                    'tools_categories' => [
                        'target_uuid' => $toolsCategory->uuid,
                    ],
                ]
            );
        });


        $bridgeContentType = new BridgeContentType();

        $allTools = Tools::query()
            ->whereIn('title', array_keys($defaultTools))
            ->get()
            ->sortBy(fn ($tool) => $defaultTools[$tool->title]);

        $defaultToolsUuids = $allTools->map(
            fn ($tool) => ['target_uuid' => $tool->uuid_host]
        )->toArray();

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'tools',
            options: [
                'title' => [
                    'fr' => 'Accès rapide',
                    'en' => 'Quick access'
                ],
                'default' => $defaultToolsUuids
            ]
        );
    }
}
