<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class UpdateProfileEditableFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $fields = collect([
            'birthday',
            'hobby',
            'skill',
            'linkedin',
            'mission'
        ]);

        $fields->each(function (string $fieldName) use ($bridge) {
            $bridge->updateFieldOptions(
                type: 'users',
                fieldName: $fieldName,
                options: [
                    'editable' => true,
                ]
            );
        });
    }
}
