<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\ContentBlueprints;
use Inside\Host\Migrations\CreateContentTypes;

class CreateFaq extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        ContentBlueprints::generateContent(contentType: 'faq_categories');
        ContentBlueprints::generateContent(contentType: 'faq_questions');
        $this->finishUp();

        Artisan::call("models:rebuild");
    }
}
