<?php

return [
    'files' => [
        'bcae' => [
            'path' => env('XLSX_USERS_PATH', __DIR__.'/../../../../imports/import.xlsx'),
            'fields' => [
                'email' => 'email',
                'name' => 'email',
                'firstname' => 'prénom',
                'lastname' => 'nom',
                'mobile_phone' => 'mobile',
                'phone' => 'téléphone',
                'function' => 'fonction',
                'referent' => 'référent',
                'parks' => fn ($user) => reference('parks')
                    ->identifiedBy('code')
                    ->from(ucfirst($user['parc']))
                    ->get(),
                'services' => fn ($user) => reference('services')
                    ->identifiedBy('code')
                    ->from(ucfirst($user['service']))
                    ->get(),
                'regions' => fn ($user) => reference('regions')
                    ->identifiedBy('code')
                    ->from(ucfirst($user['régions']))
                    ->get(),
                'manager' => fn ($user) => reference('users')
                    ->identifiedBy('email')
                    ->from(ucfirst($user['manager']))
                    ->withoutCreation()
                    ->first()
            ],
            'original_fields' => [
                'nom' => 'lastname',
                'prénom' => 'firstname',
                'email' => 'mail',
                'mobile' => 'word',
                'téléphone' => 'word',
                'fonction' => 'word',
                'parc' => 'word',
                'service' => 'word',
                'régions' => 'word',
                'manager' => 'word',
                'référent' => 'word',
            ],
        ],
    ],
];
