<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Inside\Settings\Models\Setting;

class UpdateButtonSectionColor extends Migration
{
    public function up(): void
    {
        $primaryColor = Setting::where('key', 'color_primary')
            ->value('value');

        if (!$primaryColor) {
            return;
        }

        DB::table('inside_section_button')
            ->update(['button_color' => $primaryColor]);

        $buttonColor = DB::table('inside_fields')
            ->where('name', 'button_color')
            ->select('id', 'options')
            ->first();

        if ($buttonColor && is_string($buttonColor->options ?? null)) {
            $options = json_decode($buttonColor->options, true);
            if (is_array($options)) {
                $options['default'] = $primaryColor;

                if (isset($buttonColor->id)) {
                    DB::table('inside_fields')
                        ->where('id', $buttonColor->id)
                        ->update(['options' => json_encode($options)]);
                }
            }
        }
    }
}
