<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class UpdateSearchFieldsForBcae extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $fields = collect([
            'function',
            'referent',
            'hobby',
            'skill',
            'linkedin',
            'mission'
        ]);

        $fields->each(function (string $fieldName) use ($bridge) {
            $bridge->updateFieldOptions(
                type: 'users',
                fieldName: $fieldName,
                options: [
                    'searchable' => true,
                ]
            );
        });

        Artisan::call('index:rebuild --type=users');
    }
}
