import { http } from '@inside-library/helpers/Http'

export default {
  spacesPages: {
    add: async ({ data }) => {
      const { data: spacesPage } = await http.get('content/spaces_pages', {
        fields: [
          {
            pages_categories: [
              { spaces: { fields: ['uuid', 'title', 'slug'] } }
            ]
          }
        ],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpacesPagesPage',
        params: {
          slug: spacesPage?.[0].pages_categories?.spaces?.slug?.[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data: spacesPage } = await http.get('content/spaces_pages', {
        fields: [
          {
            pages_categories: [
              { spaces: { fields: ['uuid', 'title', 'slug'] } }
            ]
          }
        ],
        filters: { 'status:eq': 1, 'uuid:eq': uuid }
      })

      return {
        name: 'SpacesPagesPage',
        params: {
          slug: spacesPage?.[0].pages_categories?.spaces?.slug?.[0]
        }
      }
    }
  },
  spaces: {
    add: ({ data }) => {
      return {
        name: 'SpacesPage',
        params: {
          slug: data.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: spaces } = await http.get('content/spaces', {
        fields: ['uuid', 'title', 'slug'],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SpacesPage',
          params: {
            slug: spaces?.[0]?.slug?.[0]
          }
        }
      }
    }
  },
  pagesCategories: {
    add: async ({ data }) => {
      const { data: category } = await http.get('content/pages_categories', {
        fields: ['uuid', 'title', 'slug', { spaces: { fields: ['slug'] } }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpacesPage',
        params: {
          slug: category?.[0].spaces?.slug?.[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: pageCategorie } = await http.get(
        'content/pages_categories',
        {
          fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
          filters: { 'status:eq': 1, 'uuid:eq': uuid }
        }
      )

      return {
        name: 'SpacesPage',
        params: {
          slug: pageCategorie?.[0].spaces?.slug?.[0]
        }
      }
    }
  },
  tabsSpaces: {
    add: async ({ data }) => {
      return {
        name: 'TabsSpacesPages',
        params: {
          slug: data.slug?.[0]
        }
      }
    }
  },
  tabs: {
    add: async ({ data }) => {
      const { data: tabs } = await http.get('content/tabs', {
        fields: ['uuid', { tabs_spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })
      return {
        name: 'TabsSpacesPages',
        params: {
          slug: tabs[0]?.tabs_spaces.slug?.[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: tabs } = await http.get('content/tabs', {
        fields: ['uuid', { tabs_spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'status:eq': 1, 'uuid:eq': uuid }
      })

      return {
        name: 'TabsSpacesPages',
        params: {
          slug: tabs?.[0].tabs_spaces?.slug?.[0]
        }
      }
    }
  },
  tabsPages: {
    add: async ({ data }) => {
      const { data: tabsPage } = await http.get('content/tabs_pages', {
        fields: [
          { tabs: [{ tabs_spaces: { fields: ['uuid', 'title', 'slug'] } }] }
        ],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'TabsSpacesPages',
        params: {
          slug: tabsPage?.[0].tabs?.tabs_spaces?.slug?.[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data: tabsPage } = await http.get('content/tabs_pages', {
        fields: [
          { tabs: [{ tabs_spaces: { fields: ['uuid', 'title', 'slug'] } }] }
        ],
        filters: { 'status:eq': 1, 'uuid:eq': uuid }
      })

      return {
        name: 'TabsSpacesPages',
        params: {
          slug: tabsPage?.[0].tabs?.tabs_spaces?.slug?.[0]
        }
      }
    }
  }
}
