import { http } from '@inside-library/helpers/Http'

export const fetchSpacesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content_type',
        'introduction',
        'banner',
        'admin',
        'presentation',
        'content',
        {
          users: {
            fields: [
              'uuid',
              'firstname',
              'lastname',
              'image',
              'function',
              'phone'
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          tools: {
            fields: [
              'title',
              'uuid',
              'has_section',
              'tools_link',
              'admin',
              'image',
              'class',
              'content_type',
              'icon',
              'icon_color'
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          documents: {
            fields: [
              'uuid',
              'content_type',
              'file',
              'title',
              'admin',
              'published_at',
              'content'
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          news_categories: {
            fields: [
              'uuid',
              'title',
              {
                news: {
                  fields: [
                    'uuid',
                    'title',
                    'slug',
                    'introduction',
                    'published_at',
                    'image',
                    'content_type',
                    { news_categories: ['uuid', 'title', 'color'] },
                    { reactions: ['count', { users: ['uuid'] }] },
                    { comments: ['count'] }
                  ],
                  filters: {
                    reverse: true,
                    'status:eq': 1,
                    sort: 'published_at:desc',
                    'published_at:lte': 'now()',
                    limit: 4
                  }
                }
              }
            ],
            filters: {
              'status:eq': 1,
              'published_at:lte': 'now()'
            }
          }
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchSpacesPagesPage = async ({ $route }) => {
  try {
    const { data: spaces } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'introduction',
        'banner'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return spaces[0]
  } catch (err) {
    throw new Error(err)
  }
}
