<?php

use Illuminate\Support\Facades\Artisan;
use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;

class AddCodeFieldsToReferences extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('directions', false);
        $this->migrateContent('localisations', false);

        $this->finishUp();

        Artisan::call('models:rebuild');

        $bridge = new BridgeContent();

        type_to_class('directions')::query()
            ->whereNull('code')
            ->pluck('title', 'uuid')
            ->each(fn ($title, $uuid) => $bridge->contentUpdate('directions', [
                'uuid' => $uuid,
                'code' => $title
            ]));

        type_to_class('localisations')::query()
            ->whereNull('code')
            ->pluck('title', 'uuid')
            ->each(fn ($title, $uuid) => $bridge->contentUpdate('localisations', [
                'uuid' => $uuid,
                'code' => $title
            ]));
    }
}
