<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateEventContentType extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'events',
            'participants_number',
            [
                'name' => 'participants_number',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 7,
                'title' => [
                    'fr' => 'Nombre de participants',
                ],
                'widget' => [
                    'type' => BridgeContentType::NUMBER_WIDGET,
                    'settings' => [],
                    'weight' => 7,
                ],
                'type' => BridgeContentType::INTEGER_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            7
        );
        $bridge->contentTypeCreateOrUpdateField(
            'events',
            'registration_enabled',
            [
                'name' => 'registration_enabled',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 8,
                'title' => [
                    'fr' => 'Activer l\'inscription aux événements',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 8,
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => false,
            ],
            8
        );
    }
}
