<?php

use Adldap\Models\Entry;
use Inside\Host\Bridge\BridgeContent;

return [
    'usernames' => [
        'ldap' => [
            'discover' => env('ADLDAP_LDAP_DISCOVER', 'mail'),
            'authenticate' => env('ADLDAP_LDAP_AUTHENTICATE', 'cn'),
        ],
        'eloquent' => env('ADLDAP_ELOQUENT_VALUE', 'email'),
    ],
    'discovering_attribute' => 'cn',
    'sync_attributes' => [
        'mail' => 'mail',
        'is_maintenance' => fn () => false,
        'name' => 'cn',
        'firstname' => 'givenname',
        'lastname' => 'sn',
        'function' => 'title',
        'mobile_phone' => 'mobile',
        'phone' => 'telephonenumber',
        'registration_number' => 'description',
        'directions' => function (Entry $user) {
            if (blank($user->department) || !is_string($user->department[0])) {
                return null;
            }

            \Inside\Content\Facades\Schema::getFieldListing('directions');

            return reference('directions')->identifiedBy('code')->from($user->department[0])->get();
        },
        'localisations' => function (Entry $user) {
            if (blank($user->l) || !is_string($user->l[0])) {
                return null;
            }

            return reference('localisations')->identifiedBy('code')->from($user->l[0])->get();
        },
        'users' => function (Entry $user) {
            if (blank($user->manager) || !is_string($user->manager[0])) {
                return null;
            }

            $cn = str($user->manager[0])->after('CN=')->before(',')->toString();

            return reference('users')->identifiedBy('name')->from($cn)->withoutCreation()->get();
        },
    ],
    'logging' => [
        'enabled' => true,
        'events' => [
            \Adldap\Laravel\Events\Importing::class => \Adldap\Laravel\Listeners\LogImport::class,
            \Adldap\Laravel\Events\Synchronized::class => \Adldap\Laravel\Listeners\LogSynchronized::class,
            \Adldap\Laravel\Events\Synchronizing::class => \Adldap\Laravel\Listeners\LogSynchronizing::class,
            \Adldap\Laravel\Events\Authenticated::class => \Adldap\Laravel\Listeners\LogAuthenticated::class,
            \Adldap\Laravel\Events\Authenticating::class => \Adldap\Laravel\Listeners\LogAuthentication::class,
            \Adldap\Laravel\Events\AuthenticationFailed::class => \Adldap\Laravel\Listeners\LogAuthenticationFailure::class,
            \Adldap\Laravel\Events\AuthenticationRejected::class => \Adldap\Laravel\Listeners\LogAuthenticationRejection::class,
            \Adldap\Laravel\Events\AuthenticationSuccessful::class => \Adldap\Laravel\Listeners\LogAuthenticationSuccess::class,
            \Adldap\Laravel\Events\DiscoveredWithCredentials::class => \Adldap\Laravel\Listeners\LogDiscovery::class,
            \Adldap\Laravel\Events\AuthenticatedWithWindows::class => \Adldap\Laravel\Listeners\LogWindowsAuth::class,
            \Adldap\Laravel\Events\AuthenticatedModelTrashed::class => \Adldap\Laravel\Listeners\LogTrashedModel::class,
        ],
    ],
];
