<?php

$customConnectionOptions = [];
if (env('ADLDAP_DONT_CHECK_TLS_CERTIFICAT', false)) {
    $customConnectionOptions[LDAP_OPT_X_TLS_REQUIRE_CERT] = LDAP_OPT_X_TLS_NEVER;
}

return [
    'logging' => env('ADLDAP_LOGGING', false),
    'connections' => [
        'rafautgroup' => [
            'auto_connect' => env('ADLDAP_AUTO_CONNECT', true),
            'connection' => Adldap\Connections\Ldap::class,
            'settings' => [
                'schema' => Adldap\Schemas\ActiveDirectory::class,
                'account_prefix' => env('ADLDAP_ADMIN_ACCOUNT_PREFIX', ''),
                'account_suffix' => env('ADLDAP_ADMIN_ACCOUNT_SUFFIX', ''),
                'hosts' => explode(' ', env('ADLDAP_CONTROLLERS_RAFAUTGROUP', 'staging.maecia.com')),
                'port' => env('ADLDAP_PORT', 389),
                'timeout' => env('ADLDAP_TIMEOUT', 5),
                'base_dn' => env('ADLDAP_BASE_DN_RAFAUTGROUP', 'dc=corp,dc=acme,dc=org'),
                'username' => env(
                    'ADLDAP_ADMIN_USERNAME_RAFAUTGROUP',
                    'cn=ndeniaud,ou=External,dc=staging2,dc=maecia,dc=com'
                ),
                'password' => env('ADLDAP_ADMIN_PASSWORD_RAFAUTGROUP', 'maecia'),
                'follow_referrals' => false,
                'use_ssl' => env('ADLDAP_USE_SSL', false),
                'use_tls' => env('ADLDAP_USE_TLS', false),
                'custom_options' => $customConnectionOptions,
            ],
        ],
        'rafaut' => [
            'auto_connect' => env('ADLDAP_AUTO_CONNECT', true),
            'connection' => Adldap\Connections\Ldap::class,
            'settings' => [
                'schema' => Adldap\Schemas\ActiveDirectory::class,
                'account_prefix' => env('ADLDAP_ADMIN_ACCOUNT_PREFIX', ''),
                'account_suffix' => env('ADLDAP_ADMIN_ACCOUNT_SUFFIX', ''),
                'hosts' => explode(' ', env('ADLDAP_CONTROLLERS_RAFAUT', 'staging.maecia.com')),
                'port' => env('ADLDAP_PORT', 389),
                'timeout' => env('ADLDAP_TIMEOUT', 5),
                'base_dn' => env('ADLDAP_BASE_DN_RAFAUT', 'dc=corp,dc=acme,dc=org'),
                'username' => env(
                    'ADLDAP_ADMIN_USERNAME_RAFAUT',
                    'cn=ndeniaud,ou=External,dc=staging2,dc=maecia,dc=com'
                ),
                'password' => env('ADLDAP_ADMIN_PASSWORD_RAFAUT', 'maecia'),
                'follow_referrals' => false,
                'use_ssl' => env('ADLDAP_USE_SSL', false),
                'use_tls' => env('ADLDAP_USE_TLS', false),
                'custom_options' => $customConnectionOptions,
            ],
        ],
        'alkan' => [
            'auto_connect' => env('ADLDAP_AUTO_CONNECT', true),
            'connection' => Adldap\Connections\Ldap::class,
            'settings' => [
                'schema' => Adldap\Schemas\ActiveDirectory::class,
                'account_prefix' => env('ADLDAP_ADMIN_ACCOUNT_PREFIX', ''),
                'account_suffix' => env('ADLDAP_ADMIN_ACCOUNT_SUFFIX', ''),
                'hosts' => explode(' ', env('ADLDAP_CONTROLLERS_ALKAN', 'staging.maecia.com')),
                'port' => env('ADLDAP_PORT', 389),
                'timeout' => env('ADLDAP_TIMEOUT', 5),
                'base_dn' => env('ADLDAP_BASE_DN_ALKAN', 'dc=corp,dc=acme,dc=org'),
                'username' => env(
                    'ADLDAP_ADMIN_USERNAME_ALKAN',
                    'cn=ndeniaud,ou=External,dc=staging2,dc=maecia,dc=com'
                ),
                'password' => env('ADLDAP_ADMIN_PASSWORD_ALKAN', 'maecia'),
                'follow_referrals' => false,
                'use_ssl' => env('ADLDAP_USE_SSL', false),
                'use_tls' => env('ADLDAP_USE_TLS', false),
                'custom_options' => $customConnectionOptions,
            ],
        ],
    ],
];
