<?php

use Illuminate\Support\Str;

return [
    'postfilter' => function ($users, $providerName) {
        $includedOU = env(strtoupper($providerName).'_INCLUDED_OU', '');

        if (empty($includedOU)) {
            return $users->reject(fn ($user) => true);
        }

        $ous = collect(explode(';', $includedOU));

        return $users->reject(function ($user) use ($ous) {
            return !$ous->some(fn ($ou) => Str::contains($user->distinguishedname[0], $ou));
        });
    },
];
