export default {
  'inside-archives': {
    isEnabled: true
  },
  'inside-edition': {
    revisionEnabled: true,
    duplicateEnabled: true
  },
  'inside-events': {
    subscriptionEnabled: true,
    showBookmarks: true,
    bookmarkEnabled: true
  },
  'inside-layouts': {
    tabsPagesBookmarkEnabled: true,
    pagesBookmarkEnabled: true,
    extraContentTypes: {
      homepage: ['media_viewer', 'tabs_spaces']
    },
    gdprContent: 'popins'
  },
  'inside-newcomers': {
    extraFields: [
      {
        field: 'user_function',
        class: 'function',
        data: data =>
          data?.user_function?.data.map(({ title }) => title).join(', ')
      }
    ]
  },
  'inside-news': {
    minimalDate: true,
    bookmarkEnabled: true,
    showBookmarks: true,
    authorEnabled: true,
    paragraphs: {
      fetchedContents: {
        requestFields: [
          'uuid',
          'title',
          'content',
          'chapo',
          'published_at',
          'slug',
          'image',
          'content_type',
          'reactions',
          'comments',
          {
            news_categories: {
              fields: ['uuid', 'title', 'color'],
              filters: { 'status:eq': 1 }
            }
          }
        ]
      }
    }
  },
  'inside-organizational-chart': {
    functionKey: 'user_function'
  },
  'inside-users': {
    csvImport: true,
    shortcuts: {
      readonlyCount: 2,
      max: 10
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'notifications', restrictions: [], icon: 'settings' },
        { name: 'password', restrictions: [] },
        { name: 'shortcuts', restrictions: [], icon: 'news' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () =>
          import('../inside-customs/components/directory/UserCard'),
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'phone',
          'image',
          { user_function: ['uuid', 'title'] }
        ]
      }
    }
  }
}
