import { http } from '@inside-library/helpers/Http'

export const fetchSpacesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'banner',
        'published_at',
        'introduction',
        'admin',
        'content_type',
        'slug',
        {
          space_cards_links: {
            fields: ['uuid', 'title', 'image', 'link', 'content_type', 'admin'],
            filters: {
              'status:eq': 1,
              sort: 'weight:asc'
            }
          }
        },
        {
          tools: {
            fields: [
              'title',
              'uuid',
              'has_section',
              'tools_link',
              'admin',
              'image',
              'class',
              'content_type',
              {
                tools_categories: [
                  'uuid',
                  { tools_categories_listings: ['uuid', 'slug'] }
                ]
              }
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          documents: {
            fields: [
              'uuid',
              'title',
              'file',
              'has_section',
              'admin',
              'content_type',
              'published_at'
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          news_categories: {
            fields: ['uuid', 'title'],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          pages_categories: {
            fields: ['count'],
            filters: { reverse: true }
          }
        }
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchSpacesPagesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'banner',
        'introduction'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
