<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class UsersMissingFieldsToCreateForApso extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('pole', false);
        $this->migrateContent('direction', false);
        $this->migrateContent('marker', false);
        $this->migrateContent('agent_location', false);
        $this->migrateContent('department', false);
        $this->migrateContent('user_function', false);
        $this->call('models:rebuild');
        $this->finishUp();

        $bridge = new BridgeContentType();

        if (Schema::hasContentType('dga')) {
            $bridge->contentTypeDelete(type: 'dga');
        }

        if (Schema::hasField('users', 'dga')) {
            $bridge->contentTypeDeleteField(
                entityType: 'user',
                type: 'user',
                fieldName: 'dga'
            );
        }

        if (Schema::hasField('users', 'function')) {
            $bridge->contentTypeDeleteField(
                entityType: 'user',
                type: 'user',
                fieldName: 'function'
            );
        }

        $referenceFieldsToCreate = [
            'pole' => 'Pôle',
            'direction' => 'Direction',
            'agent_location' => 'Emplacement de l\'agent',
            'department' => 'Service/département',
            'user_function' => 'Fonction',
        ];

        foreach ($referenceFieldsToCreate as $field => $title) {
            $bridge->contentTypeCreateOrUpdateField(
                type: 'users',
                fieldName: $field,
                options: [
                    'name' => $field,
                    'searchable' => true,
                    'translatable' => true,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => false,
                    'weight' => 5,
                    'title' => [
                        'fr' => $title,
                    ],
                    'widget' => [
                        'type' => BridgeContentType::SELECT_WIDGET,
                        'settings' => [],
                        'weight' => 6,
                    ],
                    'type' => BridgeContentType::REFERENCE_FIELD,
                    'settings' => [
                        'target_type' => [$field],
                        'cardinality' => -1,
                    ],
                    'selectable_all' => true,
                ],
                weight: 6
            );
        }

        $textFieldsToCreate = [
            'mobile' => 'Mobile',
            'teams' => 'Liens Microsoft teams',
            'dga' => 'DGA',
        ];

        foreach ($textFieldsToCreate as $field => $title) {
            $bridge->contentTypeCreateOrUpdateField(
                type: 'users',
                fieldName: $field,
                options: [
                    'name' => $field,
                    'searchable' => true,
                    'translatable' => false,
                    'search_result_field' => true,
                    'searchable_filter' => false,
                    'required' => false,
                    'weight' => 10,
                    'title' => [
                        'fr' => $title,
                    ],
                    'widget' => [
                        'type' => BridgeContentType::STRING_WIDGET,
                        'settings' => [
                            'size' => 250,
                            'placeholder' => '',
                        ],
                        'weight' => 10,
                    ],
                    'type' => BridgeContentType::TEXT_FIELD,
                    'settings' => [
                        'max_length' => 255,
                        'is_ascii' => false,
                        'case_sensitive' => false,
                        'cardinality' => 1,
                    ],
                ],
            );
        }

        Artisan::call('models:rebuild');
    }
}
