<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema;

class RemoveLangcodeForContents extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $contentTypes = Schema::getContentTypes();
        $contentTypes = array_filter($contentTypes, function ($contentType) {
            return $contentType !== 'users';
        });

        foreach ($contentTypes as $contentType) {
            if (Schema::hasField($contentType, 'langcode')) {
                $bridge->contentTypeDeleteField(
                    entityType: 'node',
                    type: $contentType,
                    fieldName: 'langcode'
                );
            }
        }
    }
}
