<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class EditableProfilInfoForApso extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $editableFields = [
            'firstname',
            'lastname',
            'phone',
        ];

        foreach ($editableFields as $field) {
            $bridge->updateFieldOptions(
                type: 'users',
                fieldName: $field,
                options: [
                    'editable' => true,
                ]
            );
        }

        $bridge->contentTypeDeleteField(
            entityType: 'user',
            type: 'user',
            fieldName: 'birthday'
        );
    }
}
