<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class RemoveLinkLabelForApso extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $contentTypes = [
            'hero_cards_links',
            'space_cards_links'
        ];

        foreach ($contentTypes as $contentType) {
            $bridge->contentTypeDeleteField(
                entityType: 'node',
                type: $contentType,
                fieldName: 'link_label'
            );
        }
    }
}
