<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class MakeUserTranslatable extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->updateContentTypeOptions(
            type: 'users',
            options: [
                'name' => 'users',
                'translatable' => true,
                'title' => [
                    'fr' => 'Utilisateur',
                    'en' => 'User',
                    'nl' => 'Gebruiker',
                    'pt' => 'Utilizador',
                    'es' => 'Espace métier',
                    'de' => 'Benutzer',
                ],
            ]
        );
    }
}
