<?php

use Illuminate\Support\Arr;

return [
    'sync_attributes' => [
        'mail' => 'mail',
        'name' => 'mail',
        'image' => true,
        'langcode' => fn () => 'fr',
        'status' => fn () => 1,
        'is_maintenance' => fn () => false,
        'firstname' => 'givenName',
        'lastname' => 'surname',
        'user_function' => fn ($user) => reference('user_function')->from($user->jobTitle)->get(),
        'phone' => fn (mixed $user) => Arr::first($user->businessPhones) ?? " ",
        'mobile' => 'mobilePhone',
        'teams' => fn (mixed $user) => "https://teams.microsoft.com/l/chat/0/0?users=$user->userPrincipalName",
        'department' => fn ($user) => reference('department')->from($user->department)->get(),
        'direction' => fn ($user) => reference('direction')->from($user->onPremisesExtensionAttributes->extensionAttribute4)->get(),
        'pole' => fn ($user) => reference('pole')->from($user->onPremisesExtensionAttributes->extensionAttribute1)->get(),
        'agent_location' => fn ($user) => reference('agent_location')->from($user->officeLocation)->get(),
        'dga' => fn ($user) => $user->onPremisesExtensionAttributes->extensionAttribute5 ? str($user->onPremisesExtensionAttributes->extensionAttribute5) : null,
    ],
];
