import { http } from '@inside-library/helpers/Http'

export const fetchProvider = async ({ $route }) => {
  try {
    const { data: provider } = await http.get('content/providers', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'informations',
        'email',
        'image',
        {
          provider_documents: {
            fields: [
              'uuid',
              'title',
              'file',
              { document_categories: ['uuid', 'title'] }
            ],
            filters: {
              'status:eq': 1,
              sort: 'title:asc',
              reverse: true
            }
          }
        },
        {
          provider_categories: {
            fields: ['uuid', 'title', 'color'],
            filters: {
              'status:eq': 1,
              sort: 'title:asc'
            }
          }
        }
      ],
      filters: {
        'status:eq': 1,
        'archived:eq': 0,
        'published_at:lte': 'now()',
        'slug:eq': $route.params.slug
      }
    })

    const { data: page } = await http.get('content/custom', {
      fields: ['uuid', 'banner'],
      filters: {
        'custom_slug:eq': 'provider-directory'
      }
    })

    return { provider: provider[0], page: page[0] }
  } catch (err) {
    throw new Error(err)
  }
}
