import { http } from '@inside-library/helpers/Http'

export const fetchProcedures = async ({ $route }) => {
  try {
    const { data } = await http.get('content/hub_procedures', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'banner',
        'introduction',
        {
          hub_block_links: {
            fields: [
              'uuid',
              'title',
              'image',
              'link',
              'open_in_new_tab',
              'admin',
              'content_type'
            ],
            filters: {
              'status:eq': 1,
              sort: 'weight:asc',
              reverse: true
            }
          }
        }
      ],
      filters: {
        'status:eq': 1,
        'archived:eq': 0,
        'published_at:lte': 'now()',
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}