import ProceduresListingPage from '../pages/procedures/ProceduresListingPage'
import { fetchProcedures } from '../components/procedures/procedures'

import CompanyPage from '../pages/company/CompanyPage'
import { fetchCompany } from '../components/company/company'

import ProviderPage from '../pages/provider-directory/ProviderPage'
import { fetchProvider } from '../components/provider-directory/provider'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    props: { filtersInput: 'selectbox' }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'EventSubscriptionPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      extraFilters: {
        sort: 'weight:asc'
      }
    }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'published_at:lte': 'now()',
        'status:eq': 1
      },
      toolsFilters: {
        sort: 'weight:asc',
        'published_at:lte': 'now()',
        'status:eq': 1
      }
    }
  },
  {
    name: 'MapPage',
    component: () => import('../pages/maps/MapPage'),
    meta: { disabled: false }
  },
  {
    name: 'ProceduresListingPage',
    path: 'listing/:slug',
    component: withFetch(ProceduresListingPage, { size: 'xxl' })(fetchProcedures),
  },
  {
    name: 'TabsSpacePage',
    meta: { disabled: false }
  },
  {
    name: 'CompanyListingPage',
    path: 'entreprises',
    component: () => import('../pages/company/CompanyListingPage')
  },
  {
    name: 'CompanyPage',
    path: 'entreprises/:slug',
    component: withFetch(CompanyPage, { size: 'xxl' })(fetchCompany)
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'ProviderDirectoryPage',
    path: 'annuaire-fournisseurs',
    component: () => import('../pages/provider-directory/ProviderDirectoryPage')
  },
  {
    name: 'ProviderPage',
    path: 'annuaire-fournisseurs/:slug',
    component: withFetch(ProviderPage, { size: 'xxl' })(fetchProvider)
  }
]
