import { http } from '@inside-library/helpers/Http'

export default {
  hubProcedures: {
    add: ({ data }) => ({
      name: 'ProceduresListingPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'HomePage'
    })
  },
  hubBlockLinks: {
    add: async ({ data }) => {
      const { data: hubBlockLinksData } = await http.get(
        'content/hub_block_links',
        {
          fields: [
            'uuid',
            {
              hub_procedures: ['uuid', 'title', 'slug']
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': data?.uuid
          }
        }
      )

      return {
        name: 'ProceduresListingPage',
        params: {
          slug: hubBlockLinksData?.[0]?.hub_procedures?.data?.[0]?.slug?.[0]
        }
      }
    },
    delete: async ({ data }) => {
      const { data: hubBlockLinksData } = await http.get(
        'content/hub_block_links',
        {
          fields: [
            'uuid',
            {
              hub_procedures: ['uuid', 'title', 'slug']
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': data.uuid
          }
        }
      )

      return {
        name: 'CompanyPage',
        params: {
          slug: hubBlockLinksData?.[0]?.hub_procedures?.data?.[0]?.slug?.[0]
        }
      }
    }
  },
  companies: {
    add: ({ data }) => ({
      name: 'CompanyPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'CompanyListingPage'
    })
  },
  companyDocuments: {
    add: async ({ data }) => {
      const { data: companyDocumentsData } = await http.get(
        'content/company_documents',
        {
          fields: [
            'uuid',
            {
              company_folders: [
                'uuid',
                'title',
                { companies: ['uuid', 'title', 'slug'] }
              ]
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': data?.uuid
          }
        }
      )

      return {
        name: 'CompanyPage',
        params: {
          slug: companyDocumentsData?.[0]?.company_folders?.companies?.slug?.[0]
        }
      }
    },
    delete: async ({ data }) => {
      const { data: companyDocumentsData } = await http.get(
        'content/company_documents',
        {
          fields: [
            'uuid',
            {
              company_folders: [
                'uuid',
                'title',
                { companies: ['uuid', 'title', 'slug'] }
              ]
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': data?.uuid
          }
        }
      )

      return {
        name: 'CompanyPage',
        params: {
          slug: companyDocumentsData?.[0]?.company_folders?.companies?.slug?.[0]
        }
      }
    }
  },
  companyFolders: {
    add: async ({ data }) => {
      const { data: companyFoldersData } = await http.get(
        'content/company_folders',
        {
          fields: [
            'uuid',
            'title',
            {
              companies: ['uuid', 'title', 'slug']
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': data?.uuid
          }
        }
      )

      return {
        name: 'CompanyPage',
        params: {
          slug: companyFoldersData?.[0].companies?.slug?.[0]
        }
      }
    },
    delete: async ({ data }) => {
      const { data: companyFoldersData } = await http.get(
        'content/company_folders',
        {
          fields: [
            'uuid',
            'title',
            {
              companies: ['uuid', 'title', 'slug']
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': data?.uuid
          }
        }
      )

      return {
        name: 'CompanyPage',
        params: {
          slug: companyFoldersData?.[0].companies?.slug?.[0]
        }
      }
    },
  },
  providers: {
    add: async ({ data }) => {
      const { data: providerData } = await http.get('content/providers', {
        fields: ['uuid', 'slug'],
        filters: {
          'uuid:eq': data?.uuid
        }
      })

      return {
        name: 'ProviderPage',
        params: {
          slug: providerData?.[0]?.slug?.[0]
        }
      }
    },
    delete: () => ({
      name: 'ProviderDirectoryPage'
    })
  },
  providerDocuments: {
    add: async ({ data }) => {
      const { data: providerDocumentData } = await http.get(
        'content/provider_documents',
        {
          fields: [
            'uuid',
            {
              providers: ['uuid', 'title', 'slug']
            }
          ],
          filters: {
            'uuid:eq': data?.uuid
          }
        }
      )

      return {
        name: 'ProviderPage',
        params: {
          slug: providerDocumentData?.[0]?.providers?.slug?.[0]
        }
      }
    },
    delete: async ({ data }) => {
      const { data: providerDocumentData } = await http.get(
        'content/provider_documents',
        {
          fields: [
            'uuid',
            {
              providers: ['uuid', 'title', 'slug']
            }
          ],
          filters: {
            'uuid:eq': data?.uuid
          }
        }
      )

      return {
        name: 'ProviderPage',
        params: {
          slug: providerDocumentData?.[0]?.providers?.slug?.[0]
        }
      }
    }
  },
  providerCategories: {
    add: () => ({
      name: 'ProviderDirectoryPage'
    }),
    delete: () => ({
      name: 'ProviderDirectoryPage'
    })
  },
  documentCategories: {
    add: () => ({
      name: 'ProviderDirectoryPage'
    }),
    delete: () => ({
      name: 'ProviderDirectoryPage'
    })
  }
}
