import { http } from '@inside-library/helpers/Http'

const fetchBottomImage = async () => {
  try {
    const { data } = await http.get('content/brands_logos_home', {
      fields: [
        'uuid',
        'title',
        'admin',
        'image',
        'link',
        'content_type'
      ],
      filters: { 'status:eq': 1, sort: 'weight:asc', limit: 1 }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchBottomImage }
