import { http } from '@inside-library/helpers/Http'

export const fetchCompany = async ({ $route }) => {
  try {
    const { data } = await http.get('content/companies', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'company_id',
        'banner',
        'chapo',
        'content',
        'company_address',
        'ape_naf',
        'capital',
        'deliverred_by',
        'mail',
        'establishment',
        'social_form',
        'company_id',
        'chapo',
        'direct_line',
        'brands',
        'declaration_number',
        'approval',
        'social_object',
        'profiles',
        'company_name',
        'siren',
        'siret',
        'vat',
        'phone',
        'rcs_city',
        {
          manager: {
            fields: ['uuid', 'firstname', 'lastname', 'function', 'phone', 'image'],
            filters: {
              'status:eq': 1,
              'is_maintenance:eq': 0
            }
          }
        },
        {
          responsible: {
            fields: ['uuid', 'firstname', 'lastname', 'function', 'phone', 'image'],
            filters: {
              'status:eq': 1,
              'is_maintenance:eq': 0
            }
          }
        },
        {
          company_folders: {
            fields: ['uuid', 'title'],
            filters: {
              reverse: true,
              'status:eq': 1,
              sort: 'published_at:desc'
            }
          }
        }
      ],
      filters: {
        'status:eq': 1,
        'archived:eq': 0,
        'published_at:lte': 'now()',
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
