export default {
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'firstname',
      'lastname',
      'image',
      'function',
      'email',
      'phone',
      'mobile_phone',
      'teams',
      {
        locations: {
          fields: ['title', 'uuid'],
          filters: { 'status:eq': 1 }
        }
      },
      {
        companies: {
          fields: ['title', 'uuid'],
          filters: { 'status:eq': 1 }
        }
      },
      {
        brands: {
          fields: ['title', 'uuid'],
          filters: { 'status:eq': 1 }
        }
      },
      {
        users: {
          fields: [
            'uuid',
            'image',
            'firstname',
            'lastname',
            'function',
            'phone'
          ],
          filters: { 'status:eq': 1, 'is_maintenance:eq': 0 }
        }
      }
    ]
  },
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      'image',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  company_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      'image',
      { company_folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  }
}
