<?php

namespace Inside\APRO\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Storage;
use Inside\Content\Models\Content;
use Inside\Host\Bridge\BridgeContent;

class MarkerSeeder extends Seeder
{
    private const TITLE = 0;
    private const COLOR = 2;
    private const LATITIDE = 3;
    private const LONGITUDE = 4;
    private const ADDRESS = 5;
    private const SCHEDULES = 6;
    private const PHONE = 7;
    private const CITY = 8;
    private const BRANDS = 9;
    private const LINK = 10;

    private BridgeContent $bridgeContent;

    public function run(): void
    {
        $this->bridgeContent = new BridgeContent();
        $filePth = "markers.csv";
        if (!Storage::disk('local')->exists($filePth)) {
            throw new \Exception("File not found: " . $filePth);
        }
        $file = Storage::disk('local')->path($filePth); // @phpstan-ignore-line
        $handle = fopen($file, 'r');
        if ($handle === false) {
            throw new \Exception("Failed to open file: " . $file);
        }
        $line = 1;

        while (($data = fgetcsv($handle, null, ',')) !== false) {
            if ($line === 1) {
                $line++;
                continue;
            }
            $maker = type_to_class('markers')::query()
                ->where('title', $data[self::TITLE])
                ->get()?->first();

            $this->addMarker($data, $maker);
        }
        fclose($handle);
    }

    private function addMarker(array $data, ?Content $marker): void
    {
        $data = [
            'title' => $data[self::TITLE],
            'color' => $data[self::COLOR],
            'address' => $data[self::ADDRESS],
            'schedules' => $data[self::SCHEDULES],
            'latitude' => $data[self::LATITIDE],
            'longitude' => $data[self::LONGITUDE],
            'link' => $data[self::LINK],
            'phone' => $data[self::PHONE],
            'brands' => reference('brands')
                ->identifiedBy('code')
                ->from(strtoupper(trim($data[self::BRANDS])))
                ->get(),
            'cities' => reference('cities')
                ->identifiedBy('code')
                ->from(strtoupper(trim($data[self::CITY])))
                ->get()
        ];
        if ($marker?->uuid) {
            $data['uuid'] = $marker->uuid;
            $data['uuid_host'] = $marker->uuid_host;
        }

        $this->bridgeContent->contentUpdate(
            type: 'markers',
            data: $data,
            fromCli: true,
            ignoreParagraphs: true
        );
    }
}
