<?php

namespace Inside\APRO\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Storage;
use Inside\Content\Models\Content;
use Inside\Host\Bridge\BridgeContent;

class CompanySeeder extends Seeder
{
    //ID Société (chcom),Profil structure,Réseau,Gérants,Etb principal ou secondaire,Lieu,Adresse,Nom commercial,Raison Sociale,"Descriptif (ex : SPID Immo/LMPI - copro, Seb Services - jardin, nettoyage ; etc.)",Téléphone,"Ligne direct de l'entreprise
    private const COMPANY_ID = 0;
    private const PROFILE = 1;
    private const NETWORK = 2;
    private const MAIN_OR_SECONDARY = 4;
    private const ADDRESS = 6;
    private const TRADE_NAME = 7;
    private const CORPORATE_NAME = 8;
    private const PHONE = 10;
    private const DIRECT_LINE = 11;
    private const EMAIL = 12;
    private const SOCIAL_OBJECT = 13;
    private const SOCIAL_FORM = 16;
    private const CAPITAL = 17;
    private const VAT_NUMBER = 18;
    private const SIREN = 19;
    private const SIRET = 20;
    private const RCS_CITY = 21;
    private const APE_NAF = 22;
    private const DECLARATION_NUMBER = 24;
    private const AGREMENT = 25;
    private const DELIVERED_BY = 26;


    private BridgeContent $bridgeContent;

    public function run(): void
    {
        $this->bridgeContent = new BridgeContent();
        $filePth = "listings_cny.csv";
        if (!Storage::disk('local')->exists($filePth)) {
            throw new \Exception("File not found: " . $filePth);
        }
        $file = Storage::disk('local')->path($filePth); // @phpstan-ignore-line
        $handle = fopen($file, 'r');
        if ($handle === false) {
            throw new \Exception("Failed to open file: " . $file);
        }
        $line = 1;

        while (($data = fgetcsv($handle, null, ',')) !== false) {
            if ($line === 1) {
                $line++;
                continue;
            }
            $company = type_to_class('companies')::query()
                ->where('company_id', $data[self::COMPANY_ID])
                ->get()?->first();

            $companyUuid = $this->addCompany($data, $company);

            if (!empty($companyUuid)) {
                $this->addCompanyFolder($data, $companyUuid);
            }
        }
        fclose($handle);
    }

    private function addCompanyFolder(array $data, string $companyUuid): void
    {
        $title = $data[self::TRADE_NAME] ?? $data[self::CORPORATE_NAME];
        $oldTitle = $data[self::CORPORATE_NAME] ?? $data[self::TRADE_NAME];

        $companyFolder = type_to_class('company_folders')::query()
            ->where('title', $title)
            ->exists();

        if ($companyFolder) {
            return;
        }

        $companyFolderData = [
            'title' => $title,
            'companies' => $companyUuid,
        ];

        $companyFolderUuid = type_to_class('company_folders')::query()
            ->with('companies')
            ->where('title', $oldTitle)
            ->whereHas('companies', fn ($query) => $query->where('uuid', $companyUuid))
            ->get()?->first()->uuid;

        if ($companyFolderUuid) {
            $companyFolderData['uuid'] = $companyFolderUuid;
        }

        $companyUuid = $this->bridgeContent->contentUpdate(
            type: 'company_folders',
            data: $companyFolderData,
            fromCli: true,
            ignoreParagraphs: true
        );
    }

    private function addCompany(array $data, ?Content $company): ?string
    {
        $data = [
            'title' => $data[self::TRADE_NAME] ?? $data[self::CORPORATE_NAME],
            'company_id' => $data[self::COMPANY_ID],
            'company_address' => $data[self::ADDRESS],
            'mail' => $data[self::EMAIL],
            'phone' => $data[self::PHONE],
            'direct_line' => $data[self::DIRECT_LINE],
            'brands' => reference('brands')
                ->identifiedBy('code')
                ->from(strtoupper(trim($data[self::NETWORK])))
                ->get(),
            'profiles' => reference('profiles')
                ->identifiedBy('code')
                ->from(strtoupper(trim($data[self::PROFILE])))
                ->get(),
            'establishment' => $data[self::MAIN_OR_SECONDARY],
            'company_name' => $data[self::CORPORATE_NAME],
            'social_object' => $data[self::SOCIAL_OBJECT],
            'social_form' => $data[self::SOCIAL_FORM],
            'capital' => $data[self::CAPITAL],
            'vat' => $data[self::VAT_NUMBER],
            'siren' => $data[self::SIREN],
            'siret' => $data[self::SIRET],
            'cities' => reference('cities')
                ->identifiedBy('code')
                ->from(strtoupper(trim($data[self::RCS_CITY])))
                ->get(),
            'ape_naf' => $data[self::APE_NAF],
            'declaration_number' => $data[self::DECLARATION_NUMBER],
            'approval' => $data[self::AGREMENT],
            'deliverred_by' => $data[self::DELIVERED_BY],
            'responsible' => null,
            'manager' => null,
        ];
        if ($company?->uuid) {
            $data['uuid'] = $company->uuid;
            $data['uuid_host'] = $company->uuid_host;
        }

        $companyUuid = $this->bridgeContent->contentUpdate(
            type: 'companies',
            data: $data,
            fromCli: true,
            ignoreParagraphs: true
        );

        return $companyUuid;
    }
}
