<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Content\Facades\Schema;

final class AproSetupMarkersCtype extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        if (Schema::hasContentType('marker')) {
            $this->getBridge()?->contentTypeDelete('marker');
            Artisan::call("models:rebuild");
        }
        Artisan::call("inside:cleanup");
        $this->migrateContent('markers', false);
        Artisan::call("models:rebuild");
        $this->finishUp();
    }
}
