<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Migrations\CreateContentTypes;

final class AproMakeUsersSearchable extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeUpdate('users', [
            'searchable' => true,
            'global_searchable' => true,
        ]);
        $this->finishUp();
        Artisan::call('index:rebuild', ['--type' => 'users']);
    }
}
