<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

final class UpdateCompanyPermissibleAttr extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        collect([
            'companies','company_documents'
        ])->each(function ($type) {
            $this->getBridge()?->contentTypeUpdate($type, [
                'permissible' => true,
            ]);
        });
        $this->finishUp();
    }
}
