<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;

class UpdateAproCnyCustom extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bridge = new BridgeContent();
        $uuid = type_to_class('custom')::where('custom_slug', 'company')->first()?->uuid;
        if ($uuid) {
            $bridge->contentDelete('custom', $uuid);
        }

        $bridge->contentInsert('custom', [
            'type' => 'node',
            'bundle' => 'custom',
            'langcode' => 'fr',
            'title' => 'Espace entreprise',
            'custom_slug' => 'company',
            'redirection_page' => 'CompanyListingPage',
        ]);
    }
}
