<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;

class UpdateBrandTypes extends Migration
{
    public function up(): void
    {
        $contents = type_to_class('brands')::all();
        $bridgeContent = new BridgeContent();
        $contents->each(function ($content) use ($bridgeContent) {
            $bridgeContent->contentUpdate(
                type: 'brands',
                data: [
                    'uuid' => $content->uuid,
                    'title' => str($content->title)->trim()->upper(),
                    'code' => str($content->title)->trim()->upper()
                ]
            );
        });
    }
}
