<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;

class CreateAproProvidersPage extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('provider_categories', false);
        $this->migrateContent('providers', false);
        $this->migrateContent('document_categories', false);
        $this->migrateContent('provider_documents', false);
        $this->call('models:rebuild');
        $this->finishUp();

        $bridge = new BridgeContent();
        $uuid = $bridge->contentInsert('custom', [
            'type' => 'node',
            'bundle' => 'custom',
            'langcode' => 'fr',
            'title' => 'Annuaire Fournisseurs',
            'custom_slug' => 'provider-directory',
            'redirection_page' => 'ProviderDirectoryPage',
        ]);
    }
}
