<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class CreateCityReferenceField extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeUpdateOrCreate(
            type: 'city',
            options: [
                    'name' => 'city',
                    'translatable' => true,
                    'searchable' => true,
                    'global_searchable' => false,
                    'aliasable' => false,
                    'permissible' => false,
                    'categorizable' => true,
                    'listing_type' => 'content',
                    'title' => [
                        'fr' => 'Ville',
                    ],
                ],
        );

        $bridge->contentTypeDeleteField(
            entityType: 'node',
            type: "franchises",
            fieldName: 'city'
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: "franchises",
            fieldName: 'city',
            options: [
                'name' => 'city',
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => true,
                'required' => true,
                'weight' => 1,
                'title' => [
                    'fr' => 'Ville',
                    ],
                    'widget' => [
                        'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                        'settings' => [],
                        'weight' => 0,
                    ],
                    'type' => BridgeContentType::REFERENCE_FIELD,
                    'settings' => [
                        'target_type' => ['city'],
                        'cardinality' => 1,
                    ],
                ],
            weight: -3
        );

        Artisan::call("models:rebuild");
    }
}
