<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Content\Facades\Schema;

class ReplaceBlocksByBlockImages extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        if (Schema::hasContentType('blocks')) {
            $bridge->contentTypeDelete('blocks');
        }

        $this->bootUp(__FILE__);
        $this->migrateContent('block_images', false);
        $this->finishUp();
    }
}
