<?php

use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Permission\Facades\Permission;

return [
    'specific_permissions_enabled' => true,
    'custom_permissions' => [
        function (string $action, string $type, ?string $uuid, ?User $user = null): bool {
            if (is_null($user)) {
                $user = Auth::user();
            }

            if (is_null($user)) {
                return false;
            }

            if ($user->permission->isSuperAdmin()) {
                return true;
            }

            if (
                in_array($action, ['create', 'update']) &&
                in_array($type, [
                    'company_documents'
                ])
            ) {
                return $user->hasRole('Contributor');
            }

            return false;
        },
    ],
    'in_add_list' => [
        'company_documents' => function (string $type): bool {
            $user = Auth::user();
            if (class_to_type($type) === 'company_documents' && $user?->is_company_contributor) {
                return true;
            }
            return false;
        }
    ]
];
