<?php

namespace Inside\APRO\Providers;

use Inside\APRO\Http\Middlewares\PermissionsFilteredByRoleMiddleware;
use Inside\Providers\ServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * APRO Service provider.
 *
 * @category Class
 * @package  Inside\\APRO\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    /**
     * Boot
     */
    public function boot(): void
    {
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');
    }

    /**
     * Register
     */
    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__ . '/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__ . '/../../config/archive.php', 'archive');
            $this->mergeConfigTo(__DIR__ . '/../../config/azuread.php', 'azuread');
            $this->mergeConfigTo(__DIR__ . '/../../config/statistics.php', 'statistics');
            $this->mergeConfigTo(__DIR__ . '/../../config/permission.php', 'permission');
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeConfigTo(__DIR__.'/../../config/user_references.php', 'user_references');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }

        $this->app->middleware([PermissionsFilteredByRoleMiddleware::class]);
    }
}
