<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

final class UpdateCompanyPermissibleAttr extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeUpdate('company_documents', [
            'permissible' => true,
        ]);
        $this->finishUp();
    }
}
