<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class CleanAproMarker extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bridge = new BridgeContentType();


        $bridge->contentTypeDeleteField(
            entityType: 'node',
            type: 'marker',
            fieldName: 'city'
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: 'marker',
            fieldName: 'cities',
            options: [
                'name' => 'cities',
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => true,
                'weight' => 4,
                'title' => [
                    'fr' => 'Ville',
                ],
                'widget' => [
                    'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                    'settings' => [],
                    'weight' => 4,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['cities'],
                    'cardinality' => 1,
                ],
            ],
            weight: 4
        );

        collect(['locations', 'cities', 'brands'])->each(function ($type) use ($bridge) {
            $bridge->updateContentTypeOptions(
                type: $type,
                options: [
                    'searchable' => true,
                    'listing_type' => 'content',
                ]
            );
        });

        $bridge->changeContentTypeTitle(type: 'cities', titles: ['fr' => 'Ville']);
        $bridge->changeContentTypeTitle(type: 'locations', titles: ['fr' => 'Localisation']);
        Artisan::call("models:rebuild");
    }
}
