<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Facades\Schema;

class CleanAproCny extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bridge = new BridgeContentType();


        if (Schema::hasContentType('city')) {
            $bridgeContent = new BridgeContent();
            $contents = type_to_class('city')::all();
            $contents->each(fn ($content) => $bridgeContent->contentDelete('city', $content->uuid));
            $bridge->contentTypeDelete('city');
        } else {
            $city = \Drupal::entityTypeManager()->getStorage('node_type')->load('city');
            if ($city) {
                $city->delete();
            }
        }

        $bridge->contentTypeDeleteField(
            entityType: 'node',
            type: 'companies',
            fieldName: 'rcs_city'
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: 'companies',
            fieldName: 'cities',
            options: [
                'name' => 'cities',
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => true,
                'weight' => 19,
                'title' => [
                    'fr' => 'Ville RCS',
                ],
                'widget' => [
                    'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                    'settings' => [],
                    'weight' => 19,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['cities'],
                    'cardinality' => 1,
                ],
            ],
            weight: 19
        );

        collect(['locations', 'cities', 'brands'])->each(function ($type) use ($bridge) {
            $bridge->updateContentTypeOptions(
                type: $type,
                options: [
                    'searchable' => true,
                ]
            );
        });

        $bridge->updateContentTypeOptions(
            type: 'companies',
            options: [
                'aliasable' => true,
                'searchable' => true,
            ]
        );
    }
}
