<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class RemoveOldFranchise extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridgeContent = new BridgeContent();

        collect([
            'franchises',
            'departments',
            'franchises_documents'
        ])->each(function ($type) use ($bridge, $bridgeContent) {
            if (Schema::hasContentType($type)) {
                $contents = type_to_class($type)::all();
                $contents->each(fn ($content) => $bridgeContent->contentDelete($type, $content->uuid));
                $bridge->contentTypeDelete($type);
            }
        });
    }
}
