<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema;
use Illuminate\Support\Facades\Artisan;

class AddReferenceFieldsInMarker extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $contentTypes = collect([
            'Ville' => 'city',
            'Marque' => 'brands',
        ]);

        $contentTypes->each(function ($machineName, $label) use ($bridge) {
            $bridge->contentTypeCreateOrUpdateField(
                type: 'marker',
                fieldName: $machineName,
                options: [
                    'name' => $machineName,
                    'searchable' => true,
                    'translatable' => true,
                    'search_result_field' => false,
                    'searchable_filter' => true,
                    'required' => true,
                    'weight' => 1,
                    'title' => [
                        'fr' => $label,
                    ],
                    'widget' => [
                        'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                        'settings' => [],
                        'weight' => 0,
                    ],
                    'type' => BridgeContentType::REFERENCE_FIELD,
                    'settings' => [
                        'target_type' => [$machineName],
                        'cardinality' => 1,
                    ],
                ],
                weight: 4
            );
        });

        Artisan::call("models:rebuild");
    }
}
