<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Support\Facades\Artisan;

class AddColorToFranchises extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'franchises',
            fieldName: 'color',
            options: [
                'name' => 'color',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 0,
                'title' => [
                    'fr' => 'Couleur du titre de la page',
                ],
                'widget' => [
                    'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                    'settings' => [],
                    'weight' => 0,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            weight: -1
        );

        Artisan::call("models:rebuild");
    }
}
